<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis rovnice staničení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis rovnice staničení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" width="90%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:for-each select="HorizontalAlignment">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br />Název trasy:&#xa0;</th>
                                                <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis trasy:&#xa0;</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Styl trasy:&#xa0;</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" class="underline" lang="en">Interní staničení</th>
                                                <th align="right" class="underline" lang="en">Původní staničení</th>
                                                <th align="right" class="underline" lang="en">Nové staničení</th>
                                                <th align="right" class="underline" lang="en">Y</th>
                                                <th align="right" class="underline" lang="en">X</th>
                                            </tr>
                                            <xsl:apply-templates/>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/station/@internalStation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/station/@internalStation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/station/@internalStation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civil prvek směrové geometrie s nejméně jednou rovnicí staničení.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
